# Block Theme Boilerplate - Wordpress Theme
[Wordpress Block Theme](https://developer.wordpress.org/themes/block-themes/) für Wordpress Version >= 5.9. 

Achtung - Stand Juni 2022: Block Themes (keine klassische Theme) sind noch immer ein experimentelles Feature!

Blocks Themes sind ein neues experimentales Feature von Wordpress 5.9 und aufwärts.
https://developer.wordpress.org/block-editor/how-to-guides/themes/block-theme-overview/


## File Structur
- `functions.php`(required): 
    - aktiviert "Default Block styles" (siehe: https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-support/#default-block-styles) 
    - läd die editor-styles (styles.css)(siehe: https://die-netzialisten.de/mit-editor-styles-das-theme-design-in-den-editor-holen/)
- `style.css` (required): 
    - Globale und editor spezifische Design Angaben (TODO: evtl. packen wir hier nur das Editor Style rein)
    - Braucht unbedingt einen gültigen Header (siehe: https://developer.wordpress.org/themes/basics/main-stylesheet-style-css/)
    - wird in der functions.php eingebunden 
- `theme.json`: Basic Configuration der Theme
- `templates/index.html` (required):
    - primär Vorlage zum Darstellen eines posts oder einer page (analog zur index.php aus dem klassischen)
- `templates/404.html`:
    - Vorlage für Seite nicht gefunden
- `templates/archive.html`:
    - .....
- `templates/page.html`:
    - Vorlage für Seiten
- `templates/single.html`:
    - Vorlage für Beiträge
- `screenshot.png`
    - screenshot der Theme (wird unter Design/Themes angezeigt)
    - Größe: 1200x900px 
- `parts/footer.html`:
    - Template Teil für den Footer jeder Seite
- `parts/header.html`:
    - Template Teil für den Header jeder Seite
- `assets/`
    - Ordner für Bilder`img` und Schriften`fonts` die Teil der Theme sind

## Theme Setup
Die Konfiguration der Theme findet hauptsächlich in der `theme.json` statt.
Die [offizielle Wordpress theme.json Dokumentention](https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-json/#settings) erklärt es ausführlicher.

### Layout Settings
Unter `settings.layout` können die Einstellungen für die Breite des Contents vorgenommen werden.
- Siehe [The Layout Settings](https://fullsiteediting.com/lessons/theme-json-layout-and-spacing-options/).

### Schriften einbinden
1. Fonts lokal speichern:
Im ordnder `assets/fonts` die entsprechenden Fonts ablegen. GoogleFonts können im [Google Font Helper](https://google-webfonts-helper.herokuapp.com/fonts) leicht heruntergeladen werden.

2. FontFamilies definieren: 
In der `theme.json` unter `settings.typography.fontFamilies` die einzelnen FontFamilies im Array definieren.
Hinweis: auf Basis der "slug" Angabe wird eine CSS-Variable für die FontFamily erstellt, nach dem schema: `var(--wp--preset--font-family--slug)`

3. FontFamilie zuweisen:
In der `theme.json` unter `styles.typography.fontFamily` kann mit Hilfe der erzeugten Variable die Schriftart für die gesamte Seite angegeben werden: `"fontFamily": "var(--wp--preset--font-family--slug)"`
Desweiteren können einzelne Element wie Überschriften etc. definiert werden unter `styles.typography.elements.<h1,h2,...>`

4. FontSizes definieren:
4.1 Default Sizes überschreiben: `settings.typography.fontsizes`
(slug": "small", "slug": "medium", "slug": "large", "slug": "x-large") - jeweils entsprechende "size" Angabe
4.2 Eigene Sizes definieren: `settings.custom` ...

- [siehe - Video Tutorial](https://youtu.be/-JwPJga5sQ0?t=2772)


### Farben Definieren
Unter `settings.color.palette` können in einem Array die Farben für die Theme definiert werden

Farben des Logos: Basis EUKO Orange + monochromatische Farben (a: roboto, c: euko, e: forschungsprojekt)
- tertiary - EUKO Orange: #F0A70A; (contrast zu weiss: 2.05:1)
- secondary - Forschungsprojekt: #BD8308; (contrast zu weiss: 3.27:1)
- primary - Reproso Braun: #704E04; (contrast zu weiss: 7.55:1)

Links:
- [Adobe Color Wheel](https://color.adobe.com/de/create/color-wheel)
- [WebAim Contrast Checker](https://webaim.org/resources/contrastchecker/)


### theme.json Aufbau
- `"$schema": "https://schemas.wp.org/trunk/theme.json"`: aktiviert Autocomplete während des Arbeitens an der theme.json
- `"version": 2`: aktuelle Version (eingeführt in Wordpress 5.9) - siehe [Wordpress Version](https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-json/#version)
- `"templateParts": [....]`: hier wurden nochmal die bereits angelegten template Parts eingefügt, so dass der titel beispielsweise im editor angezeigt wird.

### Block Patterns
- siehe [Wordpress Developer](https://developer.wordpress.org/themes/advanced-topics/block-patterns/)

## Wissenswertes

1. `<div class="wp-site-blocks">`
    - wrapper um alle templates und blöcke
    - kann nicht entfernt werden. siehe: [Creating WordPress block themes](https://fullsiteediting.com/lessons/creating-block-based-themes/)
2. Duotone (Bilder, Videos einfärben): 
    - Die SVG Icons im `<body>` sind seit Gutenberg 5.9 enthalten und notwendig für das Duotone Feature. 
    - [Duotone deactivieren](https://wordpress.org/support/topic/version-5-9-and-gutenberg-disabled-duotone-add-severals-svg-in-front-and-back/)


## Allgemeine Links
- [Wordpress Theme Handbook - Block Theme](https://developer.wordpress.org/themes/block-themes/)
- [Wordpress Block Editor Handbook](https://developer.wordpress.org/block-editor/how-to-guides/themes/block-theme-overview/)
- [A Deep Introduction to WordPress Block Themes](https://css-tricks.com/a-deep-introduction-to-wordpress-block-themes/)
- [Full site editing for theme developers - Tutorial](https://fullsiteediting.com/courses/full-site-editing-for-theme-developers/)
- [Youtube - How to Create a Custom WordPress Theme 2022 (FSE)](https://www.youtube.com/watch?v=-JwPJga5sQ0)
- [https://fullsiteediting.com/](https://fullsiteediting.com/)
- [Wordpress Theme Handbook - Block Theme](https://developer.wordpress.org/themes/block-themes/)
- [Block Theme Generator](https://fullsiteediting.com/block-theme-generator/)
- [Frost Block Theme - github](https://github.com/wpengine/frost)
- [Theme twentytwentywo](https://github.com/WordPress/twentytwentytwo)



