<?php

/**
 * This file adds functions to the Boilerplate WordPress theme.
 *
 * @package Boilerplate
 * @author  SchrammIT
 * @license GNU General Public License v2 or later
 */

/**
 * Sets up theme defaults and registers support for various WordPress features.
 * - https://developer.wordpress.org/themes/block-themes/block-theme-setup/#theme-setup-function
 */
if (!function_exists('boilerplate_setup')) {
    function boilerplate_setup() {
        // Add support for block styles (https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-support/#default-block-styles)
        add_theme_support('wp-block-styles');

		add_theme_support( 'align-wide' );

		// Add Menu Support
        add_theme_support('menus');

        // Enqueue editor styles (https://developer.wordpress.org/reference/functions/add_editor_style/)
        add_editor_style('./style.css');
    }
}
add_action('after_setup_theme', 'boilerplate_setup');

/**
 * Styles laden
 * - kopiert aus twentytwentytwo theme und namen angepasst
 */
if ( ! function_exists( 'boilerplate_styles' ) ) {
	function boilerplate_styles() {
		// Register theme stylesheet.
		$theme_version = wp_get_theme()->get( 'Version' );
		$version_string = is_string( $theme_version ) ? $theme_version : false;
        
		wp_register_style(
			'boilerplate-style',
			get_template_directory_uri() . '/style.css',
			array(),
			$version_string
		);

		// Enqueue theme stylesheet.
		wp_enqueue_style( 'boilerplate-style' );
	}
}
add_action( 'wp_enqueue_scripts', 'boilerplate_styles' );

/**
 * SVGs Upload erlauben
 * siehe: https://css-tricks.com/snippets/wordpress/allow-svg-through-wordpress-media-uploader/
 */
// Allow SVG
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

	global $wp_version;
	if ( $wp_version !== '4.7.1' ) {
	   return $data;
	}
  
	$filetype = wp_check_filetype( $filename, $mimes );
  
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
	echo '<style type="text/css">
		  .attachment-266x266, .thumbnail img {
			   width: 100% !important;
			   height: auto !important;
		  }
		  </style>';
  }
  add_action( 'admin_head', 'fix_svg' );